/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.InvalidTimeException;
import java.io.Serializable;

public class Interval
implements Serializable {
    protected int begin;
    protected int end;
    protected Object state;

    public Interval(Object object, int n, int n2, int n3, int n4) throws InvalidTimeException {
        if (n <= 23 && n3 <= 23 && n2 <= 59 && n4 <= 59 && n >= 0 && n3 >= 0 && n2 >= 0 && n4 >= 0 && n < n3 || n == n3 && n2 <= n4) {
            this.begin = (n << 8) + n2;
            this.end = (n3 << 8) + n4;
            this.state = object;
            return;
        }
        throw new InvalidTimeException();
    }

    protected Interval(Object object, int n, int n2) {
        this.begin = n;
        this.end = n2;
        this.state = object;
    }

    public Interval(Interval interval) {
        this.begin = interval.begin;
        this.end = interval.end;
        this.state = interval.state;
    }

    public static int nextMinute(int n) {
        if ((++n & 0xFF) == 60) {
            n >>= 8;
            ++n;
            n <<= 8;
        }
        return n;
    }

    public static int previousMinute(int n) {
        if ((--n & 0xFF) == 255) {
            n >>= 8;
            n <<= 8;
            n += 59;
        }
        return n;
    }

    public int beginHour() {
        return this.begin >> 8;
    }

    public int endHour() {
        return this.end >> 8;
    }

    public int beginMinute() {
        return this.begin & 0xFF;
    }

    public int endMinute() {
        return this.end & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.state.toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.begin >> 8);
        stringBuffer.append(":");
        int n = this.begin & 0xFF;
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append(" - ");
        stringBuffer.append(this.end >> 8);
        stringBuffer.append(":");
        n = this.end & 0xFF;
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append(", ");
        return stringBuffer.toString();
    }
}

